define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('GlucoseFHIRService', function (TrackersFHIRService) {
        var emptyGlucoseResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ],
            },
            code: {coding: [{system: 'http://loinc.org',code: '2345-7',display: 'Glucose [Mass/volume] in Serum or Plasma'}]},
            valueQuantity: {
                value: undefined,
                unit: "mg/dl"
            },
            valueString: undefined,
            component: [
                {
                    code: {coding: [{system:"http://snomed.info/sct",code:"162549003",display: "Eating routine (observable entity)"}]
                    },
                    valueString: undefined
                }
                
            ],
            comments: undefined,
            numericValue: true
        };

        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|2345-7',
            supportsLatest: true,

            buildResource: function (ngModel) {
                TrackersFHIRService.buildResource(ngModel);
                
                if (ngModel.numericValue) {
                    ngModel.valueString = undefined;
                } else {
                    ngModel.valueQuantity = undefined;
                }
                ngModel.numericValue = undefined;
                return ngModel;
            },

            createEmpty: function() {
                var emptyResource = angular.copy(emptyGlucoseResource);
                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource)
            },

            transformItem: function(ngModel) {
                TrackersFHIRService.transformItem(ngModel);
                if (!ngModel.valueString) {
                    ngModel.numericValue = true;
                } else {
                    ngModel.numericValue = false;
                }
            }
        });
    });
});